--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Misc
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local CloseMenu = CloseWindow

gDevDisaster = gDevDisaster or 0

-------------------------------------------------------------------------------

local function SaveGame()
	local fileName = bsgTimeStamp()
	fileName = DisplayDialog { "ui/entername.lua", name=fileName }
	if not fileName then return end
	if fileName == "" then fileName = bsgTimeStamp() end
	fileName = fileName..".choco2"
	local s = gSim:BuildSaveString()
	bsgWriteToFile(fileName, s)
end

local function LoadGame(fileName)
	local s = bsgReadFromFile(fileName)
	local f = loadstring(s)
	if type(f) == "function" then
		DebugOut("Loading: "..tostring(fileName))
		local tSave = f()
		assert(tSave and type(tSave) == "table" and tSave.mode)
		
		if tSave.mode == "free" then SetCurrentGameMode(1)
		else SetCurrentGameMode(1)
		end

		local name = GetUserName(GetCurrentUser())
		Simulator:Reset(name)
		
		gSim:LoadSaveTable(tSave)
		Simulator.lastSave = bsgCurrentTime()
		LProductType:CountAllKnownRecipes()
		ResetLedger(gSim.money or 0)
		SwapToModal("ui/map.lua")
	end
end

-------------------------------------------------------------------------------

local menu = {}
local x=0
local y=0

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#-CLOSE-", command=CloseMenu })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#Gamble: Crates", command=function() DisplayDialog { "ui/gamble_bonus.lua", char=LCharacter:ByName("sf_tutor") } CloseWindow() end })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#Gamble: Dice", command=function() DisplayDialog { "ui/gamble_dice.lua", char=LCharacter:ByName("sf_tutor") } CloseWindow() end })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#Disaster", command=function() gDevDisaster=gDevDisaster+1 gSim:Disaster(gDevDisaster) CloseWindow() end })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#Logo Editor", command=function() DoModal("ui/logoedit.lua") CloseWindow() end })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#Reload Styles", command=function() dofile("ui/styles.lua") CloseWindow() end })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#Pass one year", command=function() gSim.weeks=gSim.weeks+52 UpdateBadge(gSim) end })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#Save Game", command=function() SaveGame() CloseWindow() end })
y = y + bsgFontHeight(devfont) + 2

-------------------------------------------------------------------------------

local s = bsgNextSaveFileName()
while s ~= "" do
	local g = s..".choco2"
	s = "#Load: "..s
	table.insert(menu, DevMenuItem { x=0,y=y, w=100, label=s, command=function() LoadGame(g) end })
	y = y + bsgFontHeight(devfont) + 2
	s = bsgNextSaveFileName()
end

-------------------------------------------------------------------------------

x = gDialogTable.x or 0
y = gDialogTable.y or 0

MakeDialog
{
	Rectangle
	{
		x=x,y=y, color=devBackgroundColor, alpha=devAlpha, inset=3,
		Group(menu),
	}
}
